//+------------------------------------------------------------------+
//|                                                SAR Color Bar.mq4 |
//+------------------------------------------------------------------+
#property copyright "Kalenzo Code adapted by cja"
#property link      "http://www.foreksik.prv.pl"

#property indicator_color1 Red
#property indicator_color2 Green
#property indicator_width1 3
#property indicator_width2 3
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_maximum 1
#property indicator_minimum 0

double sarUp[],sarDn[];//buffers
extern double Step = 0.013;
extern double Maximum = 0.2;
extern int Precision = 5;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(0,sarUp);
   SetIndexBuffer(1,sarDn);
  
   
   IndicatorShortName("SAR COLORED Bar");
   SetIndexLabel(0,"SAR Up Channel");
   SetIndexLabel(1,"SAR Down Channel");
   
   SetIndexDrawBegin(0,2);
   SetIndexDrawBegin(1,2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- 
   for(int i = 0; i<limit ;i++)
   {
      double sar = NormalizeDouble(iSAR(Symbol(),0,Step,Maximum,i),Precision);
      if(sar >= iHigh(Symbol(),0,i)) 
      {
         sarUp[i] = sar;  
         sarDn[i] = 0;
      }
      else
      {
         sarUp[i] = 0;
         sarDn[i] = sar;
      }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+//+------------------------------------------------------------------+

